unit GMP3DAPI;

interface

const
 GL_S  =                              $2000       ;
 GL_T  =                              $2001       ;
 GL_R  =                              $2002       ;
 GL_Q  =                              $2003       ;
 GL_MODULATE           =              $2100       ;
 GL_DECAL              =              $2101       ;
 GL_TEXTURE_ENV_MODE   =              $2200       ;
 GL_TEXTURE_ENV_COLOR  =              $2201       ;
 GL_TEXTURE_ENV        =              $2300       ;
 GL_EYE_LINEAR         =              $2400       ;
 GL_OBJECT_LINEAR      =              $2401       ;
 GL_SPHERE_MAP         =              $2402       ;
 GL_TEXTURE_GEN_MODE   =              $2500       ;
 GL_OBJECT_PLANE       =              $2501       ;
 GL_EYE_PLANE          =              $2502       ;
 GL_NEAREST            =              $2600       ;
 GL_LINEAR             =              $2601       ;
 GL_NEAREST_MIPMAP_NEAREST     =      $2700       ;
 GL_LINEAR_MIPMAP_NEAREST      =      $2701       ;
 GL_NEAREST_MIPMAP_LINEAR      =      $2702       ;
 GL_LINEAR_MIPMAP_LINEAR       =      $2703       ;
 GL_TEXTURE_MAG_FILTER         =      $2800       ;
 GL_TEXTURE_MIN_FILTER         =      $2801       ;
 GL_TEXTURE_WRAP_S             =      $2802       ;
 GL_TEXTURE_WRAP_T             =      $2803       ;
 GL_CLAMP                      =      $2900       ;
 GL_REPEAT                     =      $2901       ;
 GL_EXT_vertex_array           =    1             ;
 GL_WIN_swap_hint              =    1             ;
 GL_VERTEX_ARRAY_EXT           =    $8074         ;
 GL_NORMAL_ARRAY_EXT           =    $8075         ;
 GL_COLOR_ARRAY_EXT            =    $8076         ;
 GL_INDEX_ARRAY_EXT            =    $8077         ;
 GL_TEXTURE_COORD_ARRAY_EXT    =    $8078         ;
 GL_EDGE_FLAG_ARRAY_EXT        =    $8079         ;
 GL_VERTEX_ARRAY_SIZE_EXT      =    $807A         ;
 GL_VERTEX_ARRAY_TYPE_EXT      =    $807B         ;
 GL_VERTEX_ARRAY_STRIDE_EXT    =    $807C         ;
 GL_VERTEX_ARRAY_COUNT_EXT     =    $807D         ;
 GL_NORMAL_ARRAY_TYPE_EXT      =    $807E         ;
 GL_NORMAL_ARRAY_STRIDE_EXT    =    $807F         ;
 GL_NORMAL_ARRAY_COUNT_EXT     =    $8080         ;
 GL_COLOR_ARRAY_SIZE_EXT       =    $8081         ;
 GL_COLOR_ARRAY_TYPE_EXT       =    $8082         ;
 GL_COLOR_ARRAY_STRIDE_EXT     =    $8083         ;
 GL_COLOR_ARRAY_COUNT_EXT      =    $8084         ;
 GL_INDEX_ARRAY_TYPE_EXT       =    $8085         ;
 GL_INDEX_ARRAY_STRIDE_EXT     =    $8086         ;
 GL_INDEX_ARRAY_COUNT_EXT      =    $8087         ;
 GL_TEXTURE_COORD_ARRAY_SIZE_EXT  = $8088         ;
 GL_TEXTURE_COORD_ARRAY_TYPE_EXT  = $8089         ;
 GL_TEXTURE_COORD_ARRAY_STRIDE_EXT= $808A         ;
 GL_TEXTURE_COORD_ARRAY_COUNT_EXT = $808B         ;
 GL_EDGE_FLAG_ARRAY_STRIDE_EXT    = $808C         ;
 GL_EDGE_FLAG_ARRAY_COUNT_EXT     = $808D         ;
 GL_VERTEX_ARRAY_POINTER_EXT      = $808E         ;
 GL_NORMAL_ARRAY_POINTER_EXT      = $808F         ;
 GL_COLOR_ARRAY_POINTER_EXT       = $8090         ;
 GL_INDEX_ARRAY_POINTER_EXT       = $8091         ;
 GL_TEXTURE_COORD_ARRAY_POINTER_EXT = $8092       ;
 GL_EDGE_FLAG_ARRAY_POINTER_EXT    = $8093        ;
 GL_COLOR_BUFFER_BIT = $00004000;
 GL_DEPTH_BUFFER_BIT = $00000100;
GL_CW  = $0900;
GL_CCW = $0901;
GL_NORMALIZE  = $0BA1;
GL_COMPILE = $00001300;
GL_PROJECTION = $00001701;
GL_MODELVIEW = $00001700;
GL_FRONT_AND_BACK = $00000408;
GL_LINE =  $00001B01;
GL_FILL =   $00001B02;
GL_POLYGON = $00000009;
GL_DEPTH_TEST = $00000B71;
GL_LIGHTING = $00000B50;
GL_LIGHT0  = $00004000;
GL_LIGHT1  = $00004001;
GL_LIGHT2  = $00004002;
GL_LIGHT3  = $00004003;
GL_LIGHT4  = $00004004;
GL_LIGHT5  = $00004005;
GL_LIGHT6  = $00004006;
GL_LIGHT7  = $00004007;
GL_FLAT =  $00001D00;
GL_SMOOTH = $00001D01;
GL_AMBIENT_AND_DIFFUSE = $00001602;
GL_FRONT  = $00000404;
GL_AMBIENT = $1200;
GL_DIFFUSE = $1201 ;
GL_SPECULAR = $1202 ;
GL_POSITION = $1203  ;
GL_SPOT_DIRECTION = $1204;
GL_SPOT_EXPONENT = $1205;
GL_SPOT_CUTOFF = $1206 ;
GL_CONSTANT_ATTENUATION = $1207;
GL_LINEAR_ATTENUATION = $1208;
GL_QUADRATIC_ATTENUATION = $1209 ;
GL_EMISSION = $1600;
GL_SHININESS = $1601;
GL_CULL_FACE = $0B44;
GL_BACK = $0405;
GL_POLYGON_SMOOTH_HINT = $0C53;
GL_BLEND  =  $0BE2;
GL_POLYGON_SMOOTH = $0B41;
GL_ONE_MINUS_SRC_ALPHA = $0303;
GL_SRC_ALPHA  = $0302;
GL_DONT_CARE = $1100;
GL_FASTEST = $1101;
GL_NICEST = $1102;
GL_SRC_ALPHA_SATURATE  = $0308;
GL_ONE = 1;
GL_FOG  =                            $0B60;
GL_FOG_INDEX =                       $0B61;
GL_FOG_DENSITY  =                    $0B62;
GL_FOG_START    =                    $0B63;
GL_FOG_END      =                    $0B64;
GL_FOG_MODE     =                    $0B65;
GL_FOG_COLOR    =                    $0B66;
GL_FOG_HINT   =                      $0C54;
GL_TRIANGLES  =                      $0004;
 GL_CURRENT_COLOR                  =  $0B00;
 GL_CURRENT_INDEX                 =   $0B01;
 GL_CURRENT_NORMAL                =   $0B02;
 GL_CURRENT_TEXTURE_COORDS        =   $0B03;
 GL_CURRENT_RASTER_COLOR          =   $0B04;
 GL_CURRENT_RASTER_INDEX          =   $0B05;
 GL_CURRENT_RASTER_TEXTURE_COORDS =   $0B06;
 GL_CURRENT_RASTER_POSITION       =   $0B07;
 GL_CURRENT_RASTER_POSITION_VALID =   $0B08;
 GL_CURRENT_RASTER_DISTANCE       =   $0B09;
 GL_POINT_SMOOTH                  =   $0B10;
 GL_POINT_SIZE                    =   $0B11;
 GL_POINT_SIZE_RANGE              =   $0B12;
 GL_POINT_SIZE_GRANULARITY        =   $0B13;
 GL_LINE_SMOOTH                   =   $0B20;
 GL_LINE_WIDTH                    =   $0B21;
 GL_LINE_WIDTH_RANGE              =   $0B22;
 GL_LINE_WIDTH_GRANULARITY        =   $0B23;
 GL_LINE_STIPPLE                  =   $0B24;
 GL_LINE_STIPPLE_PATTERN          =   $0B25;
 GL_LINE_STIPPLE_REPEAT           =   $0B26;
 GL_LIST_MODE                     =   $0B30;
 GL_MAX_LIST_NESTING              =   $0B31;
 GL_LIST_BASE                     =   $0B32;
 GL_LIST_INDEX                    =   $0B33;
 GL_POLYGON_MODE                  =   $0B40;
 GL_POLYGON_STIPPLE               =   $0B42;
 GL_EDGE_FLAG                     =   $0B43;
 GL_CULL_FACE_MODE                =   $0B45;
 GL_FRONT_FACE                    =   $0B46;
 GL_LIGHT_MODEL_LOCAL_VIEWER      =   $0B51;
 GL_LIGHT_MODEL_TWO_SIDE          =   $0B52;
 GL_LIGHT_MODEL_AMBIENT           =   $0B53;
 GL_SHADE_MODEL                   =   $0B54;
 GL_COLOR_MATERIAL_FACE           =   $0B55;
 GL_COLOR_MATERIAL_PARAMETER      =   $0B56;
 GL_COLOR_MATERIAL                =   $0B57;
 GL_DEPTH_RANGE                   =   $0B70;
 GL_DEPTH_WRITEMASK               =   $0B72;
 GL_DEPTH_CLEAR_VALUE             =   $0B73;
 GL_DEPTH_FUNC                    =   $0B74;
 GL_ACCUM_CLEAR_VALUE             =   $0B80;
 GL_STENCIL_TEST                  =   $0B90;
 GL_STENCIL_CLEAR_VALUE           =   $0B91;
 GL_STENCIL_FUNC                  =   $0B92;
 GL_STENCIL_VALUE_MASK            =   $0B93;
 GL_STENCIL_FAIL                  =   $0B94;
 GL_STENCIL_PASS_DEPTH_FAIL       =   $0B95;
 GL_STENCIL_PASS_DEPTH_PASS       =   $0B96;
 GL_STENCIL_REF                   =   $0B97;
 GL_STENCIL_WRITEMASK             =   $0B98;
 GL_MATRIX_MODE                  =    $0BA0;
 GL_VIEWPORT                     =    $0BA2;
 GL_MODELVIEW_STACK_DEPTH        =    $0BA3;
 GL_PROJECTION_STACK_DEPTH       =    $0BA4;
 GL_TEXTURE_STACK_DEPTH          =    $0BA5;
 GL_MODELVIEW_MATRIX             =    $0BA6;
 GL_PROJECTION_MATRIX            =    $0BA7;
 GL_TEXTURE_MATRIX               =    $0BA8;
 GL_ATTRIB_STACK_DEPTH           =    $0BB0;
 GL_ALPHA_TEST                   =    $0BC0;
 GL_ALPHA_TEST_FUNC              =    $0BC1;
 GL_ALPHA_TEST_REF               =    $0BC2;
 GL_DITHER                       =    $0BD0;
 GL_BLEND_DST                    =    $0BE0;
 GL_BLEND_SRC                    =    $0BE1;
 GL_LOGIC_OP_MODE                =    $0BF0;
 GL_LOGIC_OP                     =    $0BF1;
 GL_AUX_BUFFERS                  =    $0C00;
 GL_DRAW_BUFFER                  =    $0C01;
 GL_READ_BUFFER                  =    $0C02;
 GL_SCISSOR_BOX                  =    $0C10;
 GL_SCISSOR_TEST                 =    $0C11;
 GL_INDEX_CLEAR_VALUE            =    $0C20;
 GL_INDEX_WRITEMASK              =    $0C21;
 GL_COLOR_CLEAR_VALUE            =    $0C22;
 GL_COLOR_WRITEMASK              =    $0C23;
 GL_INDEX_MODE                   =    $0C30;
 GL_RGBA_MODE                    =    $0C31;
 GL_DOUBLEBUFFER                 =    $0C32;
 GL_STEREO                       =    $0C33;
 GL_RENDER_MODE                  =    $0C40;
 GL_PERSPECTIVE_CORRECTION_HINT  =    $0C50;
 GL_POINT_SMOOTH_HINT            =    $0C51;
 GL_LINE_SMOOTH_HINT             =    $0C52;
 GL_TEXTURE_GEN_S                =    $0C60;
 GL_TEXTURE_GEN_T                =    $0C61;
 GL_TEXTURE_GEN_R                =    $0C62;
 GL_TEXTURE_GEN_Q                =    $0C63;
 GL_PIXEL_MAP_I_TO_I             =    $0C70;
 GL_PIXEL_MAP_S_TO_S             =    $0C71;
 GL_PIXEL_MAP_I_TO_R             =    $0C72;
 GL_PIXEL_MAP_I_TO_G             =    $0C73;
 GL_PIXEL_MAP_I_TO_B             =    $0C74;
 GL_PIXEL_MAP_I_TO_A             =    $0C75;
 GL_PIXEL_MAP_R_TO_R             =    $0C76;
 GL_PIXEL_MAP_G_TO_G             =    $0C77;
 GL_PIXEL_MAP_B_TO_B             =    $0C78;
 GL_PIXEL_MAP_A_TO_A             =    $0C79;
 GL_PIXEL_MAP_I_TO_I_SIZE        =    $0CB0;
 GL_PIXEL_MAP_S_TO_S_SIZE        =    $0CB1;
 GL_PIXEL_MAP_I_TO_R_SIZE        =    $0CB2;
 GL_PIXEL_MAP_I_TO_G_SIZE        =    $0CB3;
 GL_PIXEL_MAP_I_TO_B_SIZE        =    $0CB4;
 GL_PIXEL_MAP_I_TO_A_SIZE        =    $0CB5;
 GL_PIXEL_MAP_R_TO_R_SIZE        =    $0CB6;
 GL_PIXEL_MAP_G_TO_G_SIZE        =    $0CB7;
 GL_PIXEL_MAP_B_TO_B_SIZE        =    $0CB8;
 GL_PIXEL_MAP_A_TO_A_SIZE        =    $0CB9;
 GL_UNPACK_SWAP_BYTES            =    $0CF0;
 GL_UNPACK_LSB_FIRST             =    $0CF1;
 GL_UNPACK_ROW_LENGTH            =    $0CF2;
 GL_UNPACK_SKIP_ROWS             =    $0CF3;
 GL_UNPACK_SKIP_PIXELS           =    $0CF4;
 GL_UNPACK_ALIGNMENT             =    $0CF5;
 GL_PACK_SWAP_BYTES              =    $0D00;
 GL_PACK_LSB_FIRST               =    $0D01;
 GL_PACK_ROW_LENGTH              =    $0D02;
 GL_PACK_SKIP_ROWS               =    $0D03;
 GL_PACK_SKIP_PIXELS             =    $0D04;
 GL_PACK_ALIGNMENT               =    $0D05;
 GL_MAP_COLOR                    =    $0D10;
 GL_MAP_STENCIL                  =    $0D11;
 GL_INDEX_SHIFT                  =    $0D12;
 GL_INDEX_OFFSET                 =    $0D13;
 GL_RED_SCALE                    =    $0D14;
 GL_RED_BIAS                     =    $0D15;
 GL_ZOOM_X                       =    $0D16;
 GL_ZOOM_Y                       =    $0D17;
 GL_GREEN_SCALE                  =    $0D18;
 GL_GREEN_BIAS                   =    $0D19;
 GL_BLUE_SCALE                   =    $0D1A;
 GL_BLUE_BIAS                    =    $0D1B;
 GL_ALPHA_SCALE                  =    $0D1C;
 GL_ALPHA_BIAS                   =    $0D1D;
 GL_DEPTH_SCALE                  =    $0D1E;
 GL_DEPTH_BIAS                   =    $0D1F;
 GL_MAX_EVAL_ORDER               =    $0D30;
 GL_MAX_LIGHTS                   =    $0D31;
 GL_MAX_CLIP_PLANES              =    $0D32;
 GL_MAX_TEXTURE_SIZE             =    $0D33;
 GL_MAX_PIXEL_MAP_TABLE          =    $0D34;
 GL_MAX_ATTRIB_STACK_DEPTH       =    $0D35;
 GL_MAX_MODELVIEW_STACK_DEPTH    =    $0D36;
 GL_MAX_NAME_STACK_DEPTH         =    $0D37;
 GL_MAX_PROJECTION_STACK_DEPTH   =    $0D38;
 GL_MAX_TEXTURE_STACK_DEPTH      =    $0D39;
 GL_MAX_VIEWPORT_DIMS            =    $0D3A;
 GL_SUBPIXEL_BITS                =    $0D50;
 GL_INDEX_BITS                   =    $0D51;
 GL_RED_BITS                     =    $0D52;
 GL_GREEN_BITS                   =    $0D53;
 GL_BLUE_BITS                    =    $0D54;
 GL_ALPHA_BITS                   =    $0D55;
 GL_DEPTH_BITS                   =    $0D56;
 GL_STENCIL_BITS                 =    $0D57;
 GL_ACCUM_RED_BITS               =    $0D58;
 GL_ACCUM_GREEN_BITS             =    $0D59;
 GL_ACCUM_BLUE_BITS              =    $0D5A;
 GL_ACCUM_ALPHA_BITS             =    $0D5B;
 GL_NAME_STACK_DEPTH             =    $0D70;
 GL_AUTO_NORMAL                  =    $0D80;
 GL_MAP1_COLOR_4                 =    $0D90;
 GL_MAP1_INDEX                   =    $0D91;
 GL_MAP1_NORMAL                  =    $0D92;
 GL_MAP1_TEXTURE_COORD_1         =    $0D93;
 GL_MAP1_TEXTURE_COORD_2         =    $0D94;
 GL_MAP1_TEXTURE_COORD_3         =    $0D95;
 GL_MAP1_TEXTURE_COORD_4         =    $0D96;
 GL_MAP1_VERTEX_3                =    $0D97;
 GL_MAP1_VERTEX_4                =    $0D98;
 GL_MAP2_COLOR_4                 =    $0DB0;
 GL_MAP2_INDEX                   =    $0DB1;
 GL_MAP2_NORMAL                  =    $0DB2;
 GL_MAP2_TEXTURE_COORD_1         =    $0DB3;
 GL_MAP2_TEXTURE_COORD_2         =    $0DB4;
 GL_MAP2_TEXTURE_COORD_3         =    $0DB5;
 GL_MAP2_TEXTURE_COORD_4         =    $0DB6;
 GL_MAP2_VERTEX_3                =    $0DB7;
 GL_MAP2_VERTEX_4                =    $0DB8;
 GL_MAP1_GRID_DOMAIN             =    $0DD0;
 GL_MAP1_GRID_SEGMENTS           =    $0DD1;
 GL_MAP2_GRID_DOMAIN             =    $0DD2;
 GL_MAP2_GRID_SEGMENTS           =    $0DD3;
 GL_TEXTURE_1D                   =    $0DE0;
 GL_TEXTURE_2D                   =    $0DE1;
 GL_DEPTH_COMPONENT            =      $1902;
 GL_RED                        =      $1903;
 GL_GREEN                      =      $1904;
 GL_BLUE                       =      $1905;
 GL_ALPHA                      =      $1906;
 GL_RGB                        =      $1907;
 GL_RGBA                       =      $1908;
 GL_LUMINANCE                  =      $1909;
 GL_LUMINANCE_ALPHA            =      $190A;
 GL_BYTE                       =      $1400;
 GL_UNSIGNED_BYTE              =      $1401;
 GL_SHORT                      =      $1402;
 GL_UNSIGNED_SHORT             =      $1403;
 GL_INT                        =      $1404;
 GL_UNSIGNED_INT               =      $1405;
 GL_FLOAT                      =      $1406;
 GL_2_BYTES                    =      $1407;
 GL_3_BYTES                    =      $1408;
 GL_4_BYTES                    =     $1409;
 GL_DOUBLE_EXT                 =      $140A;
 GL_QUADS                      =      $0007;


type
AUX_RGBImageRec = record
    sizeX, sizeY : integer;
    data : PChar;
end;
PAUX_RGBImageRec = ^AUX_RGBImageRec;


const
OpenGl32 = 'OpenGL32.dll';
Glu32 = 'Glu32.dll';
GDI32 = 'GDI32.dll';
TGMPPrim  = 'TGMPPrim.dll';

procedure DrawCylinder(width, height : Double); cdecl;
procedure DrawIcosahedron(size : double ); cdecl;
procedure DrawOctahedron(size : double ); cdecl;
procedure DrawTetrahedron(size : double ); cdecl;
procedure DrawDodecahedran(size : double ); cdecl;
procedure DrawCone(width, height : Double); cdecl;
procedure DrawTeapot(size : double); cdecl;
procedure DrawSphere(size : Double); cdecl;
procedure DrawCube(size : Double); cdecl;
procedure DrawTorus(width, circ : Double); cdecl;
function  LoadRGB(name : pChar ) : PAUX_RGBImageRec; cdecl;
function  LoadBMP(name : pChar ) : PAUX_RGBImageRec; cdecl;
procedure glPixelStorei (pname : word; param : Integer); stdcall;
procedure glBegin(mode : word); stdcall;
procedure glEnd; stdcall;
procedure glVertex3f(X,Y,Z : Single); stdcall;
procedure glNormal3f(X,Y,Z : Single); stdcall;
procedure glRotatef(Theta, X,Y,Z : Single); stdcall;
procedure glScalef(X,Y,Z : Single); stdcall;
procedure glClearColor(red,green,blue,alpha : Single); stdcall;
procedure glClear(mask : word); stdcall;
procedure glViewport(Left, Top, Width, Height : LongInt); stdcall;
procedure glMatrixMode(mode : word); stdcall;
procedure glLoadIdentity; stdcall;
procedure gluPerspective(fovy, aspect, zNear,  zFar : Double); stdcall;
procedure glColor3f(Red, Green, Blue : Single); stdcall;
procedure glTranslatef(X,Y,Z : Single); stdcall;
procedure glPolygonMode(face, mode : word);stdcall;
procedure glDisable(cap : word); stdcall;
procedure glEnable(cap : word); stdcall;
procedure glShadeModel(mode : word); stdcall;
procedure glMaterialfv(face : Word; pname : word; params : pointer); stdcall;
procedure glFlush; stdcall;
procedure glNewList(list : Integer; mode : word); stdcall;
procedure glEndList; stdcall;
procedure glCallList(list : Integer); stdcall;
procedure glFrontFace (mode : word); stdcall;
procedure glLightfv( light : word; pname : word; params : Pointer); stdcall;
procedure glCullFace(mode : Word); stdcall;
procedure glBlendFunc(sfactor, dfactor : Word); stdcall;
procedure glHint(target, mode : Word); stdcall;
procedure glFogf (pname : word; param : Single); stdcall;
procedure glFogfv (pname : word; params : Pointer); stdcall;
procedure glFogi (pname : word; param : Integer); stdcall;
procedure glFogiv (pname : word; param : Pointer); stdcall;
procedure glFrustum(Left, Right, Top, Bottom, MyNear, MyFar : Double); stdcall;
procedure glTexEnvf (target : word;pname : word; param : single); stdcall;
procedure glTexParameterf (target, pname : word; param : single); stdcall;
procedure glTexImage1D (target : word; level, components, width, border : integer; format, _type : word; pixels : pointer); stdcall;
procedure glTexImage2D (target : word; level, components, width, height, border : integer; format, _type: word; pixels : Pointer); stdcall;
procedure glTexGeni (coord, pname : word; param : integer); stdcall;
procedure glTexGenfv (coord, pname : word; params : pointer); stdcall;
procedure Box(width, height, depth : double ); cdecl
procedure glTexCoord2f (s,t : Single); stdcall;


implementation

procedure glTexGenfv ; external Opengl32 name 'glTexGenfv';
procedure glTexGeni ; external Opengl32 name 'glTexGeni';
procedure glTexImage1D; external Opengl32 name 'glTexImage1D';
procedure glTexImage2D; external Opengl32 name 'glTexImage2D';
procedure glTexParameterf; external Opengl32 name 'glTexParameterf';
procedure DrawCylinder; external TGMPPrim name 'DrawCylinder';
procedure DrawIcosahedron; external TGMPPrim name 'DrawIcosahedron';
procedure DrawOctahedron; external TGMPPrim name 'DrawOctahedron';
procedure DrawTetrahedron; external TGMPPrim name 'DrawTetrahedron';
procedure Box; external TGMPPrim name 'Box';
function  LoadRGB; external TGMPPrim name 'LoadRGB';
function  LoadBMP; external TGMPPrim name 'LoadBMP';
procedure DrawDodecahedran; external TGMPPrim name 'DrawDodecahedran';
procedure DrawCone; external TGMPPrim name 'DrawCone';
procedure DrawTeapot; external TGMPPrim name 'DrawTeapot';

procedure glTexEnvf; external Opengl32 name 'glTexEnvf';
procedure glPixelStorei; external Opengl32 name 'glPixelStorei';
procedure glFrustum; external OpenGL32 name 'glFrustum';
procedure DrawSphere; external TGMPPrim name 'DrawSphere';
procedure DrawTorus; external TGMPPrim name 'DrawTorus';
procedure DrawCube; external TGMPPrim name 'DrawCube';
procedure glFlush; external OpenGL32 name 'glFlush';
procedure glMaterialfv; external OpenGL32 name 'glMaterialfv';
procedure glShadeModel; external OpenGL32 name 'glShadeModel'
procedure glNormal3f; external Opengl32 name 'glNormal3f';
procedure glDisable; external Opengl32 name 'glDisable';
procedure glEnable; external Opengl32 name 'glEnable';
procedure glPolygonMode; external OpenGL32 name 'glPolygonMode';
procedure glBegin; external OpenGL32 name 'glBegin';
procedure glEnd; external OpenGL32 name 'glEnd';
procedure glVertex3f; external OpenGL32 name 'glVertex3f';
procedure glRotatef; external OpenGL32 name 'glRotatef';
procedure glScalef; external OpenGL32 name 'glScalef';
procedure glTranslatef; external OpenGL32 name 'glTranslatef';
procedure glClearColor ; external OpenGL32 name 'glClearColor';
procedure glClear; external OpenGL32 name 'glClear';
procedure glViewport; external OpenGL32 name 'glViewport';
procedure glMatrixMode; external OpenGL32 name 'glMatrixMode';
procedure glLoadIdentity; external Opengl32 name 'glLoadIdentity';
procedure glColor3f; external OpenGL32 name 'glColor3f';
procedure gluPerspective; external glu32 name 'gluPerspective';
procedure glNewList; external OpenGL32 name 'glNewList';
procedure glEndList; external OpenGL32 name 'glEndList';
procedure glCallList; external OpenGL32 name'glCallList';
procedure glFrontFace; external opengl32 name 'glFrontFace';
procedure glLightfv; external Opengl32 name 'glLightfv';
procedure glCullFace; external OpenGl32 name 'glCullFace';
procedure glBlendFunc; external Opengl32 name 'glBlendFunc';
procedure glHint; external Opengl32 name 'glHint';

procedure glFogf; external Opengl32 name 'glFogf';
procedure glFogfv; external Opengl32 name 'glFogfv';
procedure glFogi; external Opengl32 name 'glFogi';
procedure glFogiv; external Opengl32 name 'glFogiv';
procedure glTexCoord2f; external OpenGL32 name 'glTexCoord2f';

end.
